/**
 * Beschrijft een vliegtuig met een aantal plaatsen.
 *
 * @author Dominiek Vandewalle
 * @version 2014-11-10
 */
public class Vliegtuig
{
    private Passagier plaatsen[];//array van passagiers

    /**
     * Constructor voor objecten van de klasse Vliegtuig.
     * @param   aantalPlaatsen  Het aantal beschikbare plaatsen in het vliegtuig.
     */
    public Vliegtuig(int aantalPlaatsen)
    {
        plaatsen = new Passagier [aantalPlaatsen];
    }
    
    /**
     * Geeft het aantal plaatsen in het vliegtuig terug.
     * @return  Het aantal plaatsen in het vliegtuig.
     */
    public int aantalPlaatsen()
    {
        return plaatsen.length;
    }
    
    /**
     * Berekent het aantal aanwezige passagiers in het vliegtuig.
     * @return Het aantal passagiers.
     */
    public int aantalPassagiers()
    {
        int aantal = 0;
        
        for(Passagier passagier: plaatsen)
        {
            if(passagier != null)
            {
                aantal++;
            }
        }
        
        return aantal;
    }
    
    /**
     * Berekent het aantal vrije plaatsen in het vliegtuig.
     * @return  Het aantal vrije plaatsen.
     */    
    public int aantalVrijePlaatsen()
    {
        int aantalVrij = 0;
        
        for(int index = 0; index < plaatsen.length; index++)
        {
            if(plaatsen[index] == null)
            {
                aantalVrij++;
            }
        }
        
        return aantalVrij;
    }
    
    /**
     * Laat een passagier plaatsnemen op een plaats in het vliegtuig indien 
     * die plaats vrij is.
     * @param   passagier   De passagier die in het vliegtuig stapt.
     * @param   plaatsnummer    De plaats waar de passagier wenst te zitten.
     */
    public void stapIn(Passagier passagier, int plaatsnummer)
    {
        if(plaatsnummer >= 0 && plaatsnummer < plaatsen.length)
        {
            if(plaatsen[plaatsnummer] == null)
            {
                plaatsen[plaatsnummer] = passagier;
            }
        }
    }
    
    /**
     * Laat een passagier uit het vliegtuig stappen.
     * @param   passagier   De passagier die uitstapt.
     */
    public void stapUit(Passagier passagier)
    {
        int index = 0;
        
        while(index < plaatsen.length && plaatsen[index] != passagier)
        {
            index++;
        }
        
        if(index < plaatsen.length)
        {
            plaatsen[index] = null;
        }
    }
    
    /**
     * Toont de passagierslijst in het terminalvenster.
     */
    public void printPassagierslijst()
    {
        for(int index = 0; index < plaatsen.length; index++)
        {
            System.out.print(index + ": ");
            
            if(plaatsen[index] != null)
            {
                plaatsen[index].print();
            }
            else
            {
                System.out.println("-");
            }
        }
    }
}
